/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.VPNConnector;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.modules.objects.views.helpers.VPNConnectorListLabelProvider;
import org.netxms.nxmc.resources.StatusDisplayInfo;

public class VPNConnectorListComparator
extends ViewerComparator {
    VPNConnectorListLabelProvider lp = null;

    public VPNConnectorListComparator(VPNConnectorListLabelProvider lp) {
        this.lp = lp;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        VPNConnector vpn1 = (VPNConnector)e1;
        VPNConnector vpn2 = (VPNConnector)e2;
        int column = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
        int result = 0;
        switch (column) {
            case 0: {
                result = Long.compare(vpn1.getObjectId(), vpn2.getObjectId());
                break;
            }
            case 1: {
                result = vpn1.getObjectName().compareTo(vpn2.getObjectName());
                break;
            }
            case 2: {
                result = StatusDisplayInfo.getStatusText((ObjectStatus)vpn1.getStatus()).compareToIgnoreCase(StatusDisplayInfo.getStatusText((ObjectStatus)vpn2.getStatus()));
                break;
            }
            case 3: {
                result = this.lp.getPeerName(vpn1).compareTo(this.lp.getPeerName(vpn2));
                break;
            }
            case 4: {
                result = this.lp.getSubnetsAsString(vpn1.getLocalSubnets()).compareTo(this.lp.getSubnetsAsString(vpn2.getLocalSubnets()));
                break;
            }
            case 5: {
                result = this.lp.getSubnetsAsString(vpn1.getRemoteSubnets()).compareTo(this.lp.getSubnetsAsString(vpn2.getRemoteSubnets()));
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }
}

