/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Interface;
import org.netxms.client.topology.Port;
import org.netxms.client.topology.VlanInfo;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.modules.objects.widgets.helpers.PortInfo;

public class VlanLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Color HIGHLIGHT = new Color((Device)Display.getDefault(), 255, 216, 0);
    private NXCSession session = Registry.getSession();
    private PortInfo selectedPort = null;

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        VlanInfo vlan = (VlanInfo)element;
        switch (columnIndex) {
            case 0: {
                return Integer.toString(vlan.getVlanId());
            }
            case 1: {
                return vlan.getName();
            }
            case 2: {
                return this.buildPortList(vlan);
            }
            case 3: {
                return this.buildInterfaceList(vlan);
            }
        }
        return null;
    }

    private String buildPortList(VlanInfo vlan) {
        int i;
        int lastPort;
        ArrayList<Port> physicalPorts = new ArrayList<Port>();
        for (Port p : vlan.getPorts()) {
            Interface iface = (Interface)this.session.findObjectById(p.getObjectId(), Interface.class);
            if (iface != null) {
                if (!iface.isPhysicalPort()) {
                    Interface parent = iface.getParentInterface();
                    if (parent == null || !parent.isPhysicalPort()) continue;
                    physicalPorts.add(new Port(parent.getObjectId(), (long)parent.getIfIndex(), parent.getChassis(), parent.getModule(), parent.getPIC(), parent.getPort()));
                    continue;
                }
                physicalPorts.add(p);
                continue;
            }
            physicalPorts.add(p);
        }
        if (physicalPorts.isEmpty()) {
            return "";
        }
        Collections.sort(physicalPorts, new /* Unavailable Anonymous Inner Class!! */);
        int chassis = ((Port)physicalPorts.get(0)).getChassis();
        int module = ((Port)physicalPorts.get(0)).getModule();
        int pic = ((Port)physicalPorts.get(0)).getPIC();
        int firstPort = lastPort = ((Port)physicalPorts.get(0)).getPort();
        StringBuilder sb = new StringBuilder();
        sb.append(chassis);
        sb.append('/');
        sb.append(module);
        sb.append('/');
        sb.append(pic);
        sb.append('/');
        sb.append(firstPort);
        for (i = 1; i < physicalPorts.size(); ++i) {
            if (((Port)physicalPorts.get(i)).getChassis() == chassis && ((Port)physicalPorts.get(i)).getModule() == module && ((Port)physicalPorts.get(i)).getPIC() == pic && ((Port)physicalPorts.get(i)).getPort() == lastPort + 1) {
                ++lastPort;
                continue;
            }
            if (((Port)physicalPorts.get(i - 1)).getPort() != firstPort) {
                if (lastPort - firstPort > 1) {
                    sb.append(" - ");
                } else {
                    sb.append(", ");
                }
                sb.append(chassis);
                sb.append('/');
                sb.append(module);
                sb.append('/');
                sb.append(pic);
                sb.append('/');
                sb.append(lastPort);
            }
            chassis = ((Port)physicalPorts.get(i)).getChassis();
            module = ((Port)physicalPorts.get(i)).getModule();
            pic = ((Port)physicalPorts.get(i)).getPIC();
            firstPort = lastPort = ((Port)physicalPorts.get(i)).getPort();
            sb.append(", ");
            sb.append(chassis);
            sb.append('/');
            sb.append(module);
            sb.append('/');
            sb.append(pic);
            sb.append('/');
            sb.append(lastPort);
        }
        if (((Port)physicalPorts.get(i - 1)).getPort() != firstPort) {
            if (lastPort - firstPort > 1) {
                sb.append(" - ");
            } else {
                sb.append(", ");
            }
            sb.append(chassis);
            sb.append('/');
            sb.append(module);
            sb.append('/');
            sb.append(pic);
            sb.append('/');
            sb.append(lastPort);
        }
        return sb.toString();
    }

    private String buildInterfaceList(VlanInfo vlan) {
        StringBuilder sb = new StringBuilder();
        for (Port p : vlan.getPorts()) {
            Interface iface = (Interface)this.session.findObjectById(p.getObjectId(), Interface.class);
            if (iface == null) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(iface.getObjectName());
        }
        return sb.toString();
    }

    public boolean setSelectedPort(PortInfo selectedPort) {
        if (selectedPort == this.selectedPort) {
            return false;
        }
        this.selectedPort = selectedPort;
        return true;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return this.selectedPort != null && ((VlanInfo)element).containsPort(this.selectedPort.getChassis(), this.selectedPort.getModule(), this.selectedPort.getPIC(), this.selectedPort.getPort()) ? HIGHLIGHT : null;
    }
}

