/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objecttools.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.netxms.client.NXCSession;
import org.netxms.client.TextOutputListener;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.TextConsole;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectContext;
import org.netxms.nxmc.modules.objecttools.widgets.AbstractObjectToolExecutor;
import org.netxms.nxmc.modules.objecttools.widgets.helpers.ExecutorStateChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public abstract class AbstractObjectToolExecutor
extends Composite {
    private I18n i18n = LocalizationHelper.getI18n(AbstractObjectToolExecutor.class);
    private static final Logger logger = LoggerFactory.getLogger(AbstractObjectToolExecutor.class);
    protected final ObjectContext objectContext;
    protected final CommonContext objectToolInfo;
    protected TextConsole console;
    protected ToolBarManager toolBarManager;
    protected ToolBar toolBar;
    protected long streamId = 0L;
    protected NXCSession session;
    private TextOutputListener outputListener;
    private Font headerFont;
    private final ActionSet actions;
    private Set<ExecutorStateChangeListener> stateChangeListeners = new HashSet();
    private String failureReason = null;
    private boolean running = false;
    private boolean restartEnabled = false;
    private boolean terminateEnabled = false;
    private boolean autoScroll = true;
    private ExecutorJob job;

    public AbstractObjectToolExecutor(Composite parent, ObjectContext objectContext, ActionSet actions, CommonContext objectToolInfo) {
        super(parent, 0);
        this.objectContext = objectContext;
        this.actions = actions;
        this.session = Registry.getSession();
        this.objectToolInfo = objectToolInfo;
        this.setVisible(false);
        FontData fd = this.getFont().getFontData()[0];
        fd.setStyle(fd.getStyle() | 1);
        this.headerFont = new Font((Device)this.getDisplay(), fd);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 2;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        this.setLayout((Layout)layout);
        Label objectName = new Label((Composite)this, 16384);
        objectName.setFont(this.headerFont);
        objectName.setText(objectContext.object.getObjectName());
        GridData gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 0x1000000;
        gd.horizontalIndent = 5;
        objectName.setLayoutData((Object)gd);
        Label separator = new Label((Composite)this, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 0x1000000;
        gd.horizontalIndent = 5;
        gd.heightHint = 5;
        separator.setLayoutData((Object)gd);
        this.toolBar = new ToolBar((Composite)this, 0x800100);
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 5;
        this.toolBar.setLayoutData((Object)gd);
        this.toolBarManager = new ToolBarManager(this.toolBar);
        this.console = new TextConsole((Composite)this, 0);
        this.console.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.console.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.fillToolBar();
        this.createPopupMenu();
        this.toolBarManager.update(true);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.outputListener = new /* Unavailable Anonymous Inner Class!! */;
        this.setRunning(false);
    }

    protected void writeOutput(String text) {
        this.job.writeOutput(text);
    }

    protected TextOutputListener getOutputListener() {
        return this.outputListener;
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.console.getConsoleControl());
        this.console.getConsoleControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this.isTerminateSupported()) {
            manager.add((IAction)this.actions.actionTerminate);
        }
        manager.add((IAction)this.actions.actionRestart);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actions.actionClear);
        manager.add((IAction)this.actions.actionScrollLock);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actions.actionSelectAll);
        manager.add((IAction)this.actions.actionCopy);
    }

    private void fillToolBar() {
        if (this.isTerminateSupported()) {
            this.toolBarManager.add((IAction)this.actions.actionTerminate);
        }
        this.toolBarManager.add((IAction)this.actions.actionRestart);
        this.toolBarManager.add((IContributionItem)new Separator());
        this.toolBarManager.add((IAction)this.actions.actionClear);
        this.toolBarManager.add((IAction)this.actions.actionScrollLock);
    }

    protected void enableRestart(boolean enabled) {
        this.restartEnabled = enabled;
        this.actions.actionRestart.setEnabled(enabled);
    }

    protected void enableTerminate(boolean enabled) {
        this.terminateEnabled = enabled;
        this.actions.actionTerminate.setEnabled(enabled);
    }

    public final void execute() {
        if (this.isRunning()) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Command already running!");
            return;
        }
        this.failureReason = null;
        this.setRunning(true);
        this.job = new ExecutorJob(this, String.format(this.i18n.tr("Execute action on node %s"), this.objectContext.object.getObjectName()), this, this.console.newOutputStream());
        this.job.setUser(false);
        this.job.setSystem(true);
        this.job.start();
    }

    public final void reExecute() {
        if ((this.objectToolInfo.tool.getFlags() & 1) != 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else {
            this.execute();
        }
    }

    public void terminate() {
    }

    protected abstract void executeInternal(Display var1) throws Exception;

    protected boolean isTerminateSupported() {
        return false;
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void setRunning(boolean running) {
        this.running = running;
        this.enableRestart(!running);
        this.enableTerminate(this.isTerminateSupported() && running);
        for (ExecutorStateChangeListener l : this.stateChangeListeners) {
            l.runningStateChanged(running);
        }
    }

    public boolean isFailed() {
        return this.failureReason != null;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public void selectAll() {
        this.console.selectAll();
    }

    public void copyOutput() {
        this.console.copy();
    }

    public void clearOutput() {
        this.console.clear();
    }

    public void setAutoScroll(boolean enabled) {
        this.autoScroll = enabled;
        this.console.setAutoScroll(enabled);
    }

    public void hide() {
        this.setVisible(false);
    }

    public void show() {
        this.actions.actionCopy.setEnabled(this.console.canCopy());
        this.actions.actionRestart.setEnabled(this.restartEnabled);
        this.actions.actionTerminate.setEnabled(this.terminateEnabled);
        this.actions.actionScrollLock.setChecked(!this.autoScroll);
        this.setVisible(true);
        this.moveAbove(null);
    }

    public AbstractObject getObject() {
        return this.objectContext.object;
    }

    public void addStateChangeListener(ExecutorStateChangeListener listener) {
        this.stateChangeListeners.add(listener);
    }

    public void removeStateChangeListener(ExecutorStateChangeListener listener) {
        this.stateChangeListeners.remove(listener);
    }

    public ObjectContext getContext() {
        return this.objectContext;
    }

    public void onClone(AbstractObjectToolExecutor origin) {
        this.console.setText(origin.console.getText());
        this.setRunning(origin.isRunning());
        if (origin.isRunning()) {
            this.streamId = origin.streamId;
            this.job = origin.job;
            this.job.registerWidget(this, this.console.newOutputStream());
        }
    }
}

