/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.worldmap.widgets;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolTip;
import org.netxms.base.GeoLocation;
import org.netxms.client.NXCSession;
import org.netxms.client.TimePeriod;
import org.netxms.client.constants.TimeFrameType;
import org.netxms.client.constants.TimeUnit;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.worldmap.GeoLocationCache;
import org.netxms.nxmc.modules.worldmap.tools.Area;
import org.netxms.nxmc.modules.worldmap.tools.QuadTree;
import org.netxms.nxmc.modules.worldmap.widgets.AbstractGeoMapViewer;
import org.netxms.nxmc.modules.worldmap.widgets.GeoLocationHistoryViewer;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class GeoLocationHistoryViewer
extends AbstractGeoMapViewer {
    private final I18n i18n = LocalizationHelper.getI18n(GeoLocationHistoryViewer.class);
    private static final int START = 1;
    private static final int END = 2;
    private static final Color INNER_BORDER_COLOR = new Color((Device)Display.getCurrent(), 255, 255, 255);
    private static final Color TRACK_COLOR = new Color((Device)Display.getCurrent(), 163, 73, 164);
    private AbstractObject historyObject = null;
    private List<GeoLocation> points = new ArrayList();
    private TimePeriod timePeriod = new TimePeriod();
    private ToolTip pointToolTip = null;
    private QuadTree<GeoLocation> locationTree = new QuadTree();
    private int selectedPoint = -1;
    private Image imageStart;
    private Image imageFinish;

    public GeoLocationHistoryViewer(Composite parent, int style, View view, AbstractObject object) {
        super(parent, style, view);
        this.historyObject = object;
        this.pointToolTip = new ToolTip(this.getShell(), 4096);
        WidgetHelper.attachMouseTrackListener((Composite)this, (MouseTrackListener)new /* Unavailable Anonymous Inner Class!! */);
        this.imageStart = ResourceManager.getImage((String)"icons/start.png");
        this.imageFinish = ResourceManager.getImage((String)"icons/finish.png");
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void onMapLoad() {
        this.updateHistory();
    }

    protected void onCacheChange(AbstractObject object, GeoLocation prevLocation) {
        if (object.getObjectId() == this.historyObject.getObjectId()) {
            this.updateHistory();
        }
    }

    public void mouseMove(MouseEvent e) {
        super.mouseMove(e);
        if (this.selectedPoint != -1) {
            this.selectedPoint = -1;
            this.pointToolTip.setVisible(false);
            this.redraw();
        }
    }

    public List<GeoLocation> getAdjacentLocations(Point p) {
        return this.getAdjacentLocations(p.x, p.y);
    }

    public List<GeoLocation> getAdjacentLocations(int x, int y) {
        Point p = new Point(x, y);
        GeoLocation center = this.getLocationAtPoint(p);
        p.x -= 5;
        p.y -= 5;
        GeoLocation topLeft = this.getLocationAtPoint(p);
        p.x += 10;
        p.y += 10;
        GeoLocation bottomRight = this.getLocationAtPoint(p);
        Area area = new Area(topLeft.getLatitude(), topLeft.getLongitude(), bottomRight.getLatitude(), bottomRight.getLongitude());
        List locations = this.locationTree.query(area);
        Collections.sort(locations, new /* Unavailable Anonymous Inner Class!! */);
        return locations;
    }

    private void updateHistory() {
        NXCSession session = Registry.getSession();
        4 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    public void setTimePeriod(TimePeriod timePeriod) {
        this.timePeriod = timePeriod;
        this.updateHistory();
    }

    public TimePeriod getTimePeriod() {
        return this.timePeriod;
    }

    public void changeTimePeriod(int value, TimeUnit unit) {
        this.timePeriod.setTimeFrameType(TimeFrameType.BACK_FROM_NOW);
        this.timePeriod.setTimeRange(value);
        this.timePeriod.setTimeUnit(unit);
        this.updateHistory();
    }

    protected void drawContent(GC gc, GeoLocation currentLocation, int imgW, int imgH, int verticalOffset) {
        Point centerXY = GeoLocationCache.coordinateToDisplay((GeoLocation)currentLocation, (int)this.accessor.getZoom());
        int nextX = 0;
        int nextY = 0;
        for (int i = 0; i < this.points.size(); ++i) {
            Point virtualXY = GeoLocationCache.coordinateToDisplay((GeoLocation)((GeoLocation)this.points.get(i)), (int)this.accessor.getZoom());
            int dx = virtualXY.x - centerXY.x;
            int dy = virtualXY.y - centerXY.y + verticalOffset;
            if (i != this.points.size() - 1) {
                Point virtualXY2 = GeoLocationCache.coordinateToDisplay((GeoLocation)((GeoLocation)this.points.get(i + 1)), (int)this.accessor.getZoom());
                nextX = imgW / 2 + (virtualXY2.x - centerXY.x);
                nextY = imgH / 2 + (virtualXY2.y - centerXY.y) + verticalOffset;
            }
            int color = 3;
            if (i == this.selectedPoint) {
                color = 5;
                DateFormat df = DateFormatFactory.getDateTimeFormat();
                this.pointToolTip.setText(String.format("%s\n%s - %s", this.points.get(i), df.format(((GeoLocation)this.points.get(i)).getTimestamp()), df.format(((GeoLocation)this.points.get(i)).getEndTimestamp())));
                this.pointToolTip.setVisible(true);
            }
            if (i == 0) {
                if (i == this.points.size() - 1) {
                    nextX = imgW / 2 + dx;
                    nextY = imgH / 2 + dy;
                }
                this.drawPoint(gc, imgW / 2 + dx, imgH / 2 + dy, 1, nextX, nextY, color);
                continue;
            }
            if (i == this.points.size() - 1) {
                this.drawPoint(gc, imgW / 2 + dx, imgH / 2 + dy, 2, nextX, nextY, color);
                continue;
            }
            this.drawPoint(gc, imgW / 2 + dx, imgH / 2 + dy, 0, nextX, nextY, color);
        }
    }

    private void drawPoint(GC gc, int x, int y, int flag, int prevX, int prevY, int color) {
        if (flag == 1 || flag == 2) {
            Image image;
            if (flag == 1) {
                gc.setForeground(TRACK_COLOR);
                gc.setLineWidth(3);
                gc.drawLine(x, y, prevX, prevY);
            }
            gc.setBackground(this.getDisplay().getSystemColor(color));
            gc.fillOval(x - 5, y - 5, 10, 10);
            Image image2 = image = flag == 1 ? this.imageStart : this.imageFinish;
            if (image == null) {
                image = SharedIcons.IMG_EMPTY;
            }
            int w = image.getImageData().width + 24;
            int h = image.getImageData().height + 24;
            Rectangle rect = new Rectangle(x - w / 2 - 1, y - 20 - h, w, h);
            gc.setBackground(TRACK_COLOR);
            gc.fillArc(rect.x, rect.y, rect.width, rect.height, 0, 360);
            gc.setLineWidth(2);
            gc.setForeground(INNER_BORDER_COLOR);
            gc.drawArc(rect.x + 4, rect.y + 4, rect.width - 8, rect.height - 8, 0, 360);
            gc.setLineWidth(1);
            int[] arrow = new int[]{rect.x + rect.width / 2 - 3, rect.y + rect.height - 1, x, y, rect.x + rect.width / 2 + 4, rect.y + rect.height - 1};
            gc.fillPolygon(arrow);
            gc.drawImage(image, rect.x + 12, rect.y + 12);
        } else {
            gc.setForeground(TRACK_COLOR);
            gc.setLineWidth(3);
            gc.drawLine(x, y, prevX, prevY);
            gc.setBackground(Display.getCurrent().getSystemColor(color));
            gc.fillOval(x - 5, y - 5, 10, 10);
        }
    }

    public AbstractObject getObjectAtPoint(Point p) {
        return null;
    }
}

