/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.tools;

import org.eclipse.swt.widgets.Display;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewStateListener;
import org.netxms.nxmc.tools.VisibilityValidator;

public class ViewRefreshController
implements ViewStateListener {
    private Runnable timer;
    private Runnable handler;
    private VisibilityValidator validator;
    private View view;
    private Display display;
    private int interval;
    private boolean disposed = false;

    public ViewRefreshController(View view, int interval, Runnable handler) {
        this(view, interval, handler, null);
    }

    public ViewRefreshController(View view, int interval, Runnable handler, VisibilityValidator validator) {
        this.handler = handler;
        this.validator = validator;
        this.interval = interval;
        this.view = view;
        this.display = view.getDisplay();
        this.timer = new /* Unavailable Anonymous Inner Class!! */;
        view.addStateListener((ViewStateListener)this);
        if (interval > 0) {
            this.display.timerExec(interval * 1000, this.timer);
        }
    }

    public void setInterval(int interval) {
        this.interval = interval;
        this.display.timerExec(-1, this.timer);
        if (interval > 0) {
            this.display.timerExec(interval * 1000, this.timer);
        }
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.view.removeStateListener((ViewStateListener)this);
        this.display.timerExec(-1, this.timer);
        this.disposed = true;
    }

    public void viewActivated(View view) {
        if (this.interval > 0 && (this.validator == null || this.validator.isVisible())) {
            this.handler.run();
        }
    }

    public void viewDeactivated(View view) {
    }

    public void viewClosed(View view) {
        this.display.asyncExec(() -> this.dispose());
    }
}

