/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.util.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.codehaus.commons.nullanalysis.NotNullByDefault;

public final class Proxies {
    private Proxies() {
    }

    public static <T> T newInstance(final Object delegate, final Method ... methodsAndDelegateMethod) {
        Class<?> declaringInterface = methodsAndDelegateMethod[0].getDeclaringClass();
        assert (declaringInterface.isInterface());
        for (int i = 0; i < methodsAndDelegateMethod.length; i += 2) {
            Method method = methodsAndDelegateMethod[i];
            Method delegateMethod = methodsAndDelegateMethod[i + 1];
            assert (method.getDeclaringClass().equals(declaringInterface));
            delegateMethod.setAccessible(true);
            assert (method.getReturnType().equals(delegateMethod.getReturnType()));
            assert (Arrays.equals(method.getParameterTypes(), delegateMethod.getParameterTypes()));
        }
        Object result2 = Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{declaringInterface}, new InvocationHandler(){

            @Override
            @NotNullByDefault(value=false)
            public Object invoke(Object proxy, Method actualMethod, Object[] args) throws Throwable {
                Method delegateMethod;
                block4: {
                    for (int i = 0; i < methodsAndDelegateMethod.length; i += 2) {
                        Method method = methodsAndDelegateMethod[i];
                        delegateMethod = methodsAndDelegateMethod[i + 1];
                        if (!actualMethod.equals(method)) {
                            continue;
                        }
                        break block4;
                    }
                    String message2 = "Expected invocation of [";
                    for (int i = 2; i < methodsAndDelegateMethod.length; i += 2) {
                        Method method = methodsAndDelegateMethod[i];
                        if (i > 0) {
                            message2 = message2 + ", ";
                        }
                        message2 = message2 + method;
                    }
                    message2 = message2 + "], but was " + actualMethod;
                    throw new AssertionError((Object)message2);
                }
                return delegateMethod.invoke(delegate, args);
            }
        });
        return (T)result2;
    }
}

