/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import org.netxms.base.NXCPMessage;

public class PostalAddress {
    public String country;
    public String region;
    public String city;
    public String district;
    public String streetAddress;
    public String postcode;

    public PostalAddress() {
        this.country = "";
        this.region = "";
        this.city = "";
        this.district = "";
        this.streetAddress = "";
        this.postcode = "";
    }

    public PostalAddress(String country, String region, String city, String district, String streetAddress, String postcode) {
        this.country = country;
        this.region = region;
        this.city = city;
        this.district = district;
        this.streetAddress = streetAddress;
        this.postcode = postcode;
    }

    public PostalAddress(PostalAddress src) {
        this.country = src.country;
        this.region = src.region;
        this.city = src.city;
        this.district = src.district;
        this.streetAddress = src.streetAddress;
        this.postcode = src.postcode;
    }

    public PostalAddress(NXCPMessage msg) {
        this.country = msg.getFieldAsString(486L);
        this.region = msg.getFieldAsString(782L);
        this.city = msg.getFieldAsString(487L);
        this.district = msg.getFieldAsString(783L);
        this.streetAddress = msg.getFieldAsString(488L);
        this.postcode = msg.getFieldAsString(489L);
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setField(486L, this.country);
        msg.setField(782L, this.region);
        msg.setField(487L, this.city);
        msg.setField(783L, this.district);
        msg.setField(488L, this.streetAddress);
        msg.setField(489L, this.postcode);
    }

    public String getAddressLine() {
        StringBuilder sb = new StringBuilder();
        if (!this.streetAddress.isEmpty()) {
            sb.append(this.streetAddress);
        }
        if (!this.district.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.district);
        }
        if (!this.city.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.city);
        }
        if (!this.region.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.region);
        }
        if (!this.postcode.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.postcode);
        }
        if (!this.country.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.country);
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.country.isEmpty() && this.region.isEmpty() && this.city.isEmpty() && this.district.isEmpty() && this.streetAddress.isEmpty() && this.postcode.isEmpty();
    }

    public String toString() {
        return this.getAddressLine();
    }
}

