/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.ai;

import java.util.List;
import org.netxms.base.NXCPMessage;

public class AiQuestion {
    private long id;
    private int chatId;
    private boolean multipleChoice;
    private ConfirmationType confirmationType;
    private String text;
    private String context;
    private List<String> options;
    private int timeoutSeconds;

    public AiQuestion(NXCPMessage msg) {
        this.id = msg.getFieldAsInt64(890L);
        this.chatId = msg.getFieldAsInt32(875L);
        this.multipleChoice = msg.getFieldAsInt32(891L) == 1;
        int confType = msg.getFieldAsInt32(892L);
        this.confirmationType = confType >= 0 && confType < ConfirmationType.values().length ? ConfirmationType.values()[confType] : ConfirmationType.APPROVE_REJECT;
        this.text = msg.getFieldAsString(893L);
        this.context = msg.getFieldAsString(894L);
        this.options = msg.getFieldAsStringList(898L);
        this.timeoutSeconds = msg.getFieldAsInt32(895L);
    }

    public long getId() {
        return this.id;
    }

    public int getChatId() {
        return this.chatId;
    }

    public boolean isMultipleChoice() {
        return this.multipleChoice;
    }

    public ConfirmationType getConfirmationType() {
        return this.confirmationType;
    }

    public String getPositiveLabel() {
        switch (this.confirmationType) {
            case APPROVE_REJECT: {
                return "Approve";
            }
            case YES_NO: {
                return "Yes";
            }
            case CONFIRM_CANCEL: {
                return "Confirm";
            }
        }
        return "Yes";
    }

    public String getNegativeLabel() {
        switch (this.confirmationType) {
            case APPROVE_REJECT: {
                return "Reject";
            }
            case YES_NO: {
                return "No";
            }
            case CONFIRM_CANCEL: {
                return "Cancel";
            }
        }
        return "No";
    }

    public String getText() {
        return this.text;
    }

    public String getContext() {
        return this.context;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public static enum ConfirmationType {
        APPROVE_REJECT,
        YES_NO,
        CONFIRM_CANCEL;

    }
}

