/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AiMessageType {
    INFORMATIONAL(0),
    ALERT(1),
    APPROVAL_REQUEST(2),
    UNKNOWN(-1);

    private static Logger logger;
    private static Map<Integer, AiMessageType> lookupTable;
    private int value;

    private AiMessageType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AiMessageType getByValue(int value) {
        AiMessageType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(AiMessageType.class);
        lookupTable = new HashMap<Integer, AiMessageType>();
        for (AiMessageType element : AiMessageType.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

