/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AuthenticationType {
    PASSWORD(0),
    CERTIFICATE(1),
    SSO_TICKET(2),
    TOKEN(3);

    private static Logger logger;
    private static Map<Integer, AuthenticationType> lookupTable;
    private int value;

    private AuthenticationType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AuthenticationType getByValue(int value) {
        AuthenticationType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return PASSWORD;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(AuthenticationType.class);
        lookupTable = new HashMap<Integer, AuthenticationType>();
        for (AuthenticationType element : AuthenticationType.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

