/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ConnectionPointType {
    INDIRECT(0),
    DIRECT(1),
    WIRELESS(2),
    UNKNOWN(3),
    NOT_FOUND(4);

    private static Logger logger;
    private static Map<Integer, ConnectionPointType> lookupTable;
    private int value;

    private ConnectionPointType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ConnectionPointType getByValue(int value) {
        ConnectionPointType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(ConnectionPointType.class);
        lookupTable = new HashMap<Integer, ConnectionPointType>();
        for (ConnectionPointType element : ConnectionPointType.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

