/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NodeType {
    UNKNOWN(0),
    PHYSICAL(1),
    VIRTUAL(2),
    CONTROLLER(3),
    CONTAINER(4);

    private static Logger logger;
    private static Map<Integer, NodeType> lookupTable;
    private int value;

    private NodeType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static NodeType getByValue(int value) {
        NodeType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(NodeType.class);
        lookupTable = new HashMap<Integer, NodeType>();
        for (NodeType element : NodeType.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

