/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PackageDeploymentStatus {
    UNKNOWN(-1),
    SCHEDULED(0),
    PENDING(1),
    INITIALIZING(2),
    FILE_TRANSFER_RUNNING(3),
    INSTALLATION_RUNNING(4),
    WAITING_FOR_AGENT(5),
    COMPLETED(6),
    FAILED(7),
    CANCELLED(8);

    private static Logger logger;
    private static Map<Integer, PackageDeploymentStatus> lookupTable;
    private int value;

    private PackageDeploymentStatus(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static PackageDeploymentStatus getByValue(int value) {
        PackageDeploymentStatus element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(PackageDeploymentStatus.class);
        lookupTable = new HashMap<Integer, PackageDeploymentStatus>();
        for (PackageDeploymentStatus element : PackageDeploymentStatus.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

