/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.netxms.base.NXCPMessage;

public class MeasurementUnit {
    public static final MeasurementUnit BYTES_IEC = new MeasurementUnit("B (IEC)");
    public static final MeasurementUnit BYTES_METRIC = new MeasurementUnit("B");
    public static final MeasurementUnit BPS_IEC = new MeasurementUnit("bps (IEC)");
    public static final MeasurementUnit BPS_METRIC = new MeasurementUnit("bps");
    public static final MeasurementUnit HZ = new MeasurementUnit("Hz");
    public static final Set<String> UNITS_WITHOUT_MULTIPLIERS = new HashSet<String>(Arrays.asList("%", "\u00b0C", "\u00b0F", "dBm", "rpm"));
    private String name;
    private boolean binary;

    protected MeasurementUnit() {
        this.name = "";
        this.binary = false;
    }

    public MeasurementUnit(String name) {
        this.name = name.replace(" (IEC)", "").replace(" (Metric)", "");
        this.binary = name.contains(" (IEC)");
    }

    public MeasurementUnit(NXCPMessage msg, long baseId) {
        this(msg.getFieldAsString(baseId));
    }

    public String getName() {
        return this.name;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public boolean useMultiplierForUnit() {
        return !UNITS_WITHOUT_MULTIPLIERS.contains(this.name);
    }

    public String toString() {
        return "MeasurementUnit [name=" + this.name + ", binary=" + this.binary + "]";
    }
}

