/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.ActionExecutionConfiguration;
import org.netxms.client.events.TimeFrame;

public class EventProcessingPolicyRule {
    public static final int STOP_PROCESSING = 1;
    public static final int NEGATED_SOURCE = 2;
    public static final int NEGATED_EVENTS = 4;
    public static final int GENERATE_ALARM = 8;
    public static final int DISABLED = 16;
    public static final int TERMINATE_BY_REGEXP = 32;
    public static final int SEVERITY_NORMAL = 256;
    public static final int SEVERITY_WARNING = 512;
    public static final int SEVERITY_MINOR = 1024;
    public static final int SEVERITY_MAJOR = 2048;
    public static final int SEVERITY_CRITICAL = 4096;
    public static final int CREATE_TICKET = 8192;
    public static final int ACCEPT_CORRELATED = 16384;
    public static final int NEGATED_TIME_FRAMES = 32768;
    public static final int START_DOWNTIME = 65536;
    public static final int END_DOWNTIME = 131072;
    public static final int REQUEST_AI_COMMENT = 262144;
    public static final int CREATE_INCIDENT = 524288;
    public static final int AI_ANALYZE_INCIDENT = 0x100000;
    public static final int AI_AUTO_ASSIGN = 0x200000;
    public static final int SEVERITY_ANY = 7936;
    private UUID guid;
    private List<Long> sources;
    private List<Long> sourceExclusions;
    private List<Integer> events;
    private String filterScript;
    private List<TimeFrame> timeFrames;
    private int flags;
    private String alarmKey;
    private String alarmMessage;
    private Severity alarmSeverity;
    private int alarmTimeout;
    private int alarmTimeoutEvent;
    private List<Long> alarmCategoryIds;
    private String rcaScriptName;
    private String downtimeTag;
    private int incidentDelay;
    private String incidentTitle;
    private String incidentDescription;
    private int incidentAIAnalysisDepth;
    private String incidentAIPrompt;
    private String actionScript;
    private List<ActionExecutionConfiguration> actions;
    private List<String> timerCancellations;
    private Map<String, String> persistentStorageSet;
    private List<String> persistentStorageDelete;
    private Map<String, String> customAttributeStorageSet;
    private List<String> customAttributeStorageDelete;
    private String aiAgentInstructions;
    private String comments;
    private int ruleNumber;
    private int version;
    private boolean modified;
    private UUID modifiedByGuid;
    private String modifiedByName;
    private long modificationTime;

    public EventProcessingPolicyRule() {
        this.guid = UUID.randomUUID();
        this.sources = new ArrayList<Long>(0);
        this.sourceExclusions = new ArrayList<Long>(0);
        this.events = new ArrayList<Integer>(0);
        this.filterScript = "";
        this.timeFrames = new ArrayList<TimeFrame>();
        this.flags = 7936;
        this.alarmKey = "";
        this.alarmMessage = "%m";
        this.alarmSeverity = Severity.UNKNOWN;
        this.alarmTimeout = 0;
        this.alarmTimeoutEvent = 43;
        this.alarmCategoryIds = new ArrayList<Long>(0);
        this.rcaScriptName = null;
        this.downtimeTag = "";
        this.incidentDelay = 0;
        this.incidentTitle = "";
        this.incidentDescription = "";
        this.incidentAIAnalysisDepth = 0;
        this.incidentAIPrompt = null;
        this.actionScript = null;
        this.actions = new ArrayList<ActionExecutionConfiguration>(0);
        this.timerCancellations = new ArrayList<String>(0);
        this.persistentStorageSet = new HashMap<String, String>(0);
        this.persistentStorageDelete = new ArrayList<String>(0);
        this.customAttributeStorageSet = new HashMap<String, String>(0);
        this.customAttributeStorageDelete = new ArrayList<String>(0);
        this.aiAgentInstructions = "";
        this.comments = "";
        this.ruleNumber = 0;
        this.version = 0;
        this.modified = true;
        this.modifiedByGuid = null;
        this.modifiedByName = null;
        this.modificationTime = 0L;
    }

    public EventProcessingPolicyRule(EventProcessingPolicyRule src) {
        this.guid = UUID.randomUUID();
        this.sources = new ArrayList<Long>(src.sources);
        this.sourceExclusions = new ArrayList<Long>(src.sourceExclusions);
        this.events = new ArrayList<Integer>(src.events);
        this.filterScript = src.filterScript;
        this.timeFrames = new ArrayList<TimeFrame>(src.timeFrames.size());
        for (TimeFrame timeFrame : src.timeFrames) {
            this.timeFrames.add(new TimeFrame(timeFrame));
        }
        this.flags = src.flags;
        this.alarmKey = src.alarmKey;
        this.alarmMessage = src.alarmMessage;
        this.alarmSeverity = src.alarmSeverity;
        this.alarmTimeout = src.alarmTimeout;
        this.alarmTimeoutEvent = src.alarmTimeoutEvent;
        this.alarmCategoryIds = src.alarmCategoryIds;
        this.rcaScriptName = src.rcaScriptName;
        this.downtimeTag = src.downtimeTag;
        this.incidentDelay = src.incidentDelay;
        this.incidentTitle = src.incidentTitle;
        this.incidentDescription = src.incidentDescription;
        this.incidentAIAnalysisDepth = src.incidentAIAnalysisDepth;
        this.incidentAIPrompt = src.incidentAIPrompt;
        this.actionScript = src.actionScript;
        this.actions = new ArrayList<ActionExecutionConfiguration>(src.actions.size());
        for (ActionExecutionConfiguration actionExecutionConfiguration : src.actions) {
            this.actions.add(new ActionExecutionConfiguration(actionExecutionConfiguration));
        }
        this.timerCancellations = new ArrayList<String>(src.timerCancellations);
        this.persistentStorageSet = new HashMap<String, String>(src.persistentStorageSet);
        this.persistentStorageDelete = new ArrayList<String>(src.persistentStorageDelete);
        this.customAttributeStorageSet = new HashMap<String, String>(src.customAttributeStorageSet);
        this.customAttributeStorageDelete = new ArrayList<String>(src.customAttributeStorageDelete);
        this.aiAgentInstructions = src.aiAgentInstructions;
        this.comments = src.comments;
        this.ruleNumber = src.ruleNumber;
        this.version = 0;
        this.modified = true;
        this.modifiedByGuid = null;
        this.modifiedByName = null;
        this.modificationTime = 0L;
    }

    public EventProcessingPolicyRule(NXCPMessage msg, int ruleNumber) {
        this.guid = msg.getFieldAsUUID(222L);
        this.sources = Arrays.asList(msg.getFieldAsUInt32ArrayEx(71L));
        this.sourceExclusions = Arrays.asList(msg.getFieldAsUInt32ArrayEx(808L));
        this.events = Arrays.asList(msg.getFieldAsInt32ArrayEx(72L));
        this.filterScript = msg.getFieldAsString(228L);
        int frameCount = msg.getFieldAsInt32(812L);
        this.timeFrames = new ArrayList<TimeFrame>(frameCount);
        long fieldId = 0x70000000L;
        for (int i = 0; i < frameCount; ++i) {
            this.timeFrames.add(new TimeFrame(msg.getFieldAsInt32(fieldId++), msg.getFieldAsInt64(fieldId++)));
        }
        this.flags = msg.getFieldAsInt32(13L);
        this.alarmKey = msg.getFieldAsString(64L);
        this.alarmMessage = msg.getFieldAsString(66L);
        this.alarmSeverity = Severity.getByValue(msg.getFieldAsInt32(63L));
        this.alarmTimeout = msg.getFieldAsInt32(65L);
        this.alarmTimeoutEvent = msg.getFieldAsInt32(283L);
        this.alarmCategoryIds = Arrays.asList(msg.getFieldAsUInt32ArrayEx(555L));
        this.rcaScriptName = msg.getFieldAsString(670L);
        this.downtimeTag = msg.getFieldAsString(330L);
        this.incidentDelay = msg.getFieldAsInt32(889L);
        this.incidentTitle = msg.getFieldAsString(882L);
        this.incidentDescription = msg.getFieldAsString(883L);
        this.incidentAIAnalysisDepth = msg.getFieldAsInt32(901L);
        this.incidentAIPrompt = msg.getFieldAsString(902L);
        this.actionScript = msg.getFieldAsString(805L);
        this.aiAgentInstructions = msg.getFieldAsString(271L);
        this.comments = msg.getFieldAsString(82L);
        int actionCount = msg.getFieldAsInt32(70L);
        this.actions = new ArrayList<ActionExecutionConfiguration>(actionCount);
        fieldId = 0x50000000L;
        for (int i = 0; i < actionCount; ++i) {
            this.actions.add(new ActionExecutionConfiguration(msg, fieldId));
            fieldId += 10L;
        }
        this.timerCancellations = msg.getFieldAsStringList(829L);
        this.persistentStorageSet = msg.getStringMapFromFields(0x10000000L, 305L);
        this.persistentStorageDelete = msg.getStringListFromFields(0x20000000L, 303L);
        this.customAttributeStorageSet = msg.getStringMapFromFields(0x30000000L, 806L);
        this.customAttributeStorageDelete = msg.getStringListFromFields(0x40000000L, 807L);
        this.ruleNumber = ruleNumber;
        this.version = msg.getFieldAsInt32(920L);
        this.modified = false;
        this.modifiedByGuid = msg.getFieldAsUUID(922L);
        this.modifiedByName = msg.getFieldAsString(923L);
        this.modificationTime = msg.getFieldAsInt64(406L);
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setField(222L, this.guid);
        msg.setFieldInt32(13L, this.flags);
        msg.setField(82L, this.comments);
        msg.setField(228L, this.filterScript);
        msg.setFieldInt32(70L, this.actions.size());
        long fieldId = 0x50000000L;
        for (ActionExecutionConfiguration d : this.actions) {
            d.fillMessage(msg, fieldId);
            fieldId += 10L;
        }
        msg.setFieldStringCollection(829L, this.timerCancellations);
        msg.setField(72L, this.events);
        msg.setField(71L, this.sources);
        msg.setField(808L, this.sourceExclusions);
        msg.setFieldInt32(812L, this.timeFrames.size());
        fieldId = 0x70000000L;
        for (TimeFrame frame : this.timeFrames) {
            frame.fillMessage(msg, fieldId);
            fieldId += 2L;
        }
        msg.setField(64L, this.alarmKey);
        msg.setField(66L, this.alarmMessage);
        msg.setFieldInt16(63L, this.alarmSeverity.getValue());
        msg.setFieldInt32(65L, this.alarmTimeout);
        msg.setFieldInt32(283L, this.alarmTimeoutEvent);
        msg.setField(555L, this.alarmCategoryIds);
        msg.setField(670L, this.rcaScriptName);
        msg.setField(330L, this.downtimeTag);
        msg.setFieldInt32(889L, this.incidentDelay);
        msg.setField(882L, this.incidentTitle);
        msg.setField(883L, this.incidentDescription);
        msg.setFieldInt32(901L, this.incidentAIAnalysisDepth);
        msg.setField(902L, this.incidentAIPrompt);
        msg.setField(805L, this.actionScript);
        msg.setField(271L, this.aiAgentInstructions);
        msg.setFieldsFromStringMap(this.persistentStorageSet, 0x10000000L, 305L);
        msg.setFieldsFromStringCollection(this.persistentStorageDelete, 0x20000000L, 303L);
        msg.setFieldsFromStringMap(this.customAttributeStorageSet, 0x30000000L, 806L);
        msg.setFieldsFromStringCollection(this.customAttributeStorageDelete, 0x40000000L, 807L);
        msg.setFieldInt32(920L, this.version);
        msg.setField(926L, this.modified);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
        this.modified = true;
    }

    public String getFilterScript() {
        return this.filterScript;
    }

    public void setFilterScript(String script) {
        this.filterScript = script;
        this.modified = true;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
        this.modified = true;
    }

    public String getAlarmKey() {
        return this.alarmKey;
    }

    public void setAlarmKey(String alarmKey) {
        this.alarmKey = alarmKey;
        this.modified = true;
    }

    public String getAlarmMessage() {
        return this.alarmMessage;
    }

    public void setAlarmMessage(String alarmMessage) {
        this.alarmMessage = alarmMessage;
        this.modified = true;
    }

    public Severity getAlarmSeverity() {
        return this.alarmSeverity;
    }

    public void setAlarmSeverity(Severity alarmSeverity) {
        this.alarmSeverity = alarmSeverity;
        this.modified = true;
    }

    public int getAlarmTimeout() {
        return this.alarmTimeout;
    }

    public void setAlarmTimeout(int alarmTimeout) {
        this.alarmTimeout = alarmTimeout;
        this.modified = true;
    }

    public int getAlarmTimeoutEvent() {
        return this.alarmTimeoutEvent;
    }

    public void setAlarmTimeoutEvent(int alarmTimeoutEvent) {
        this.alarmTimeoutEvent = alarmTimeoutEvent;
        this.modified = true;
    }

    public List<Long> getAlarmCategories() {
        return this.alarmCategoryIds;
    }

    public void setAlarmCategories(List<Long> alarmCategoryIds) {
        this.alarmCategoryIds = alarmCategoryIds;
        this.modified = true;
    }

    public void removeAlarmCategory(Long categoryId) {
        for (int i = 0; i < this.alarmCategoryIds.size(); ++i) {
            if (this.alarmCategoryIds.get(i) != categoryId) continue;
            this.alarmCategoryIds.remove(i);
            this.modified = true;
            break;
        }
    }

    public String getRcaScriptName() {
        return this.rcaScriptName;
    }

    public void setRcaScriptName(String rcaScriptName) {
        this.rcaScriptName = rcaScriptName;
        this.modified = true;
    }

    public List<Long> getSources() {
        return this.sources;
    }

    public List<Long> getSourceExclusions() {
        return this.sourceExclusions;
    }

    public void setSourceExclusions(List<Long> sourceExclusions) {
        this.sourceExclusions = sourceExclusions;
        this.modified = true;
    }

    public List<Integer> getEvents() {
        return this.events;
    }

    public List<ActionExecutionConfiguration> getActions() {
        return this.actions;
    }

    public Map<String, String> getPStorageSet() {
        return this.persistentStorageSet;
    }

    public List<String> getPStorageDelete() {
        return this.persistentStorageDelete;
    }

    public void setSources(List<Long> sources) {
        this.sources = sources;
        this.modified = true;
    }

    public void setEvents(List<Integer> events) {
        this.events = events;
        this.modified = true;
    }

    public void setActions(List<ActionExecutionConfiguration> actions) {
        this.actions = actions;
        this.modified = true;
    }

    public List<String> getTimerCancellations() {
        return this.timerCancellations;
    }

    public void setTimerCancellations(List<String> timerCancellations) {
        this.timerCancellations = timerCancellations;
        this.modified = true;
    }

    public void setPStorageSet(Map<String, String> persistentStorageSet) {
        this.persistentStorageSet = persistentStorageSet;
        this.modified = true;
    }

    public void setPStorageDelete(List<String> persistentStorageDelete) {
        this.persistentStorageDelete = persistentStorageDelete;
        this.modified = true;
    }

    public boolean isFilterEmpty() {
        return this.sources.isEmpty() && this.sourceExclusions.isEmpty() && this.events.isEmpty() && this.filterScript.isBlank() && this.timeFrames.isEmpty() && (this.flags & 0x1F00) == 7936;
    }

    public boolean isDisabled() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isSourceInverted() {
        return (this.flags & 2) != 0;
    }

    public boolean isEventsInverted() {
        return (this.flags & 4) != 0;
    }

    public boolean isTimeFramesInverted() {
        return (this.flags & 0x8000) != 0;
    }

    public boolean isCorrelatedEventProcessingAllowed() {
        return (this.flags & 0x4000) != 0;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public int getRuleNumber() {
        return this.ruleNumber;
    }

    public void setRuleNumber(int ruleNumber) {
        this.ruleNumber = ruleNumber;
    }

    public String getActionScript() {
        return this.actionScript;
    }

    public void setActionScript(String actionScript) {
        this.actionScript = actionScript;
        this.modified = true;
    }

    public Map<String, String> getCustomAttributeStorageSet() {
        return this.customAttributeStorageSet;
    }

    public void setCustomAttributeStorageSet(Map<String, String> customAttributeStorageSet) {
        this.customAttributeStorageSet = customAttributeStorageSet;
        this.modified = true;
    }

    public List<String> getCustomAttributeStorageDelete() {
        return this.customAttributeStorageDelete;
    }

    public void setCustomAttributeStorageDelete(List<String> customAttributeStorageDelete) {
        this.customAttributeStorageDelete = customAttributeStorageDelete;
        this.modified = true;
    }

    public List<TimeFrame> getTimeFrames() {
        return this.timeFrames;
    }

    public void setTimeFrames(List<TimeFrame> timeFrames) {
        this.timeFrames = timeFrames;
        this.modified = true;
    }

    public String getDowntimeTag() {
        return this.downtimeTag;
    }

    public void setDowntimeTag(String downtimeTag) {
        this.downtimeTag = downtimeTag;
        this.modified = true;
    }

    public int getIncidentDelay() {
        return this.incidentDelay;
    }

    public void setIncidentDelay(int incidentDelay) {
        this.incidentDelay = incidentDelay;
        this.modified = true;
    }

    public String getIncidentTitle() {
        return this.incidentTitle;
    }

    public void setIncidentTitle(String incidentTitle) {
        this.incidentTitle = incidentTitle != null ? incidentTitle : "";
        this.modified = true;
    }

    public String getIncidentDescription() {
        return this.incidentDescription;
    }

    public void setIncidentDescription(String incidentDescription) {
        this.incidentDescription = incidentDescription != null ? incidentDescription : "";
        this.modified = true;
    }

    public int getIncidentAIAnalysisDepth() {
        return this.incidentAIAnalysisDepth;
    }

    public void setIncidentAIAnalysisDepth(int incidentAIAnalysisDepth) {
        this.incidentAIAnalysisDepth = incidentAIAnalysisDepth;
        this.modified = true;
    }

    public String getIncidentAIPrompt() {
        return this.incidentAIPrompt != null ? this.incidentAIPrompt : "";
    }

    public void setIncidentAIPrompt(String incidentAIPrompt) {
        this.incidentAIPrompt = incidentAIPrompt;
        this.modified = true;
    }

    public String getAiAgentInstructions() {
        return this.aiAgentInstructions;
    }

    public void setAiAgentInstructions(String aiAgentInstructions) {
        this.aiAgentInstructions = aiAgentInstructions;
        this.modified = true;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version2) {
        this.version = version2;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void clearModified() {
        this.modified = false;
    }

    public UUID getModifiedByGuid() {
        return this.modifiedByGuid;
    }

    public String getModifiedByName() {
        return this.modifiedByName;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }
}

