/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.Set;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.PollState;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.interfaces.AutoBindObject;
import org.netxms.client.objects.interfaces.PollingTarget;

public class Circuit
extends DataCollectionTarget
implements AutoBindObject,
PollingTarget {
    private int autoBindFlags;
    private String autoBindFilter;

    public Circuit(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.autoBindFilter = msg.getFieldAsString(321L);
        this.autoBindFlags = msg.getFieldAsInt32(625L);
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    @Override
    public boolean isAlarmsVisible() {
        return true;
    }

    @Override
    public boolean isAutoBindEnabled() {
        return (this.autoBindFlags & 1) > 0;
    }

    @Override
    public boolean isAutoUnbindEnabled() {
        return (this.autoBindFlags & 2) > 0;
    }

    @Override
    public String getAutoBindFilter() {
        return this.autoBindFilter;
    }

    @Override
    public String getObjectClassName() {
        return "Circuit";
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public Set<String> getStrings() {
        Set<String> strings = super.getStrings();
        Circuit.addString(strings, this.autoBindFilter);
        return strings;
    }

    @Override
    public int getAutoBindFlags() {
        return this.autoBindFlags;
    }

    @Override
    public int getIfXTablePolicy() {
        return 0;
    }

    @Override
    public AgentCacheMode getAgentCacheMode() {
        return null;
    }

    @Override
    public long getPollerNodeId() {
        return 0L;
    }

    @Override
    public boolean canHaveAgent() {
        return false;
    }

    @Override
    public boolean canHaveInterfaces() {
        return false;
    }

    @Override
    public boolean canHavePollerNode() {
        return false;
    }

    @Override
    public boolean canUseEtherNetIP() {
        return false;
    }

    @Override
    public boolean canUseModbus() {
        return false;
    }

    @Override
    public PollState[] getPollStates() {
        return this.pollStates;
    }
}

