/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.packages;

import java.util.Date;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.PackageDeploymentStatus;

public class PackageDeploymentJob {
    private long id;
    private long nodeId;
    private int userId;
    private PackageDeploymentStatus status;
    private Date creationTime;
    private Date executionTime;
    private Date completionTime;
    private long packageId;
    private String packageType;
    private String packageName;
    private String platform;
    private String version;
    private String packageFile;
    private String command;
    private String description;
    private String errorMessage;

    public PackageDeploymentJob(NXCPMessage msg, long baseId) {
        this.id = msg.getFieldAsInt64(baseId);
        this.nodeId = msg.getFieldAsInt64(baseId + 1L);
        this.userId = msg.getFieldAsInt32(baseId + 2L);
        this.status = PackageDeploymentStatus.getByValue(msg.getFieldAsInt32(baseId + 3L));
        this.creationTime = msg.getFieldAsDate(baseId + 4L);
        this.executionTime = msg.getFieldAsDate(baseId + 5L);
        this.completionTime = msg.getFieldAsDate(baseId + 6L);
        this.packageId = msg.getFieldAsInt64(baseId + 7L);
        this.packageType = msg.getFieldAsString(baseId + 8L);
        this.packageName = msg.getFieldAsString(baseId + 9L);
        this.platform = msg.getFieldAsString(baseId + 10L);
        this.version = msg.getFieldAsString(baseId + 11L);
        this.packageFile = msg.getFieldAsString(baseId + 12L);
        this.command = msg.getFieldAsString(baseId + 13L);
        this.description = msg.getFieldAsString(baseId + 14L);
        this.errorMessage = msg.getFieldAsString(baseId + 15L);
    }

    public long getId() {
        return this.id;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public int getUserId() {
        return this.userId;
    }

    public PackageDeploymentStatus getStatus() {
        return this.status;
    }

    public boolean isActive() {
        return this.status != PackageDeploymentStatus.SCHEDULED && this.status != PackageDeploymentStatus.COMPLETED && this.status != PackageDeploymentStatus.FAILED && this.status != PackageDeploymentStatus.CANCELLED;
    }

    public boolean isFinished() {
        return this.status == PackageDeploymentStatus.COMPLETED || this.status == PackageDeploymentStatus.FAILED || this.status == PackageDeploymentStatus.CANCELLED;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getExecutionTime() {
        return this.executionTime;
    }

    public Date getCompletionTime() {
        return this.completionTime;
    }

    public long getPackageId() {
        return this.packageId;
    }

    public String getPackageType() {
        return this.packageType;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackageFile() {
        return this.packageFile;
    }

    public String getCommand() {
        return this.command;
    }

    public String getDescription() {
        return this.description;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

