/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.snmp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netxms.base.NXCPDataInputStream;
import org.netxms.client.NXCException;
import org.netxms.client.snmp.SnmpObjectId;

public class MibObject {
    public static final int STATUS_MANDATORY = 1;
    public static final int STATUS_OPTIONAL = 2;
    public static final int STATUS_OBSOLETE = 3;
    public static final int STATUS_DEPRECATED = 4;
    public static final int STATUS_CURRENT = 5;
    public static final int ACCESS_READONLY = 1;
    public static final int ACCESS_READWRITE = 2;
    public static final int ACCESS_WRITEONLY = 3;
    public static final int ACCESS_NOACCESS = 4;
    public static final int ACCESS_NOTIFY = 5;
    public static final int ACCESS_CREATE = 6;
    public static final int MIB_TYPE_OTHER = 0;
    public static final int MIB_TYPE_IMPORT_ITEM = 1;
    public static final int MIB_TYPE_OBJID = 2;
    public static final int MIB_TYPE_BITSTRING = 3;
    public static final int MIB_TYPE_INTEGER = 4;
    public static final int MIB_TYPE_INTEGER32 = 5;
    public static final int MIB_TYPE_INTEGER64 = 6;
    public static final int MIB_TYPE_UNSIGNED32 = 7;
    public static final int MIB_TYPE_COUNTER = 8;
    public static final int MIB_TYPE_COUNTER32 = 9;
    public static final int MIB_TYPE_COUNTER64 = 10;
    public static final int MIB_TYPE_GAUGE = 11;
    public static final int MIB_TYPE_GAUGE32 = 12;
    public static final int MIB_TYPE_TIMETICKS = 13;
    public static final int MIB_TYPE_OCTETSTR = 14;
    public static final int MIB_TYPE_OPAQUE = 15;
    public static final int MIB_TYPE_IPADDR = 16;
    public static final int MIB_TYPE_PHYSADDR = 17;
    public static final int MIB_TYPE_NETADDR = 18;
    public static final int MIB_TYPE_NAMED_TYPE = 19;
    public static final int MIB_TYPE_SEQID = 20;
    public static final int MIB_TYPE_SEQUENCE = 21;
    public static final int MIB_TYPE_CHOICE = 22;
    public static final int MIB_TYPE_TEXTUAL_CONVENTION = 23;
    public static final int MIB_TYPE_MACRO_DEFINITION = 24;
    public static final int MIB_TYPE_MODCOMP = 25;
    public static final int MIB_TYPE_TRAPTYPE = 26;
    public static final int MIB_TYPE_NOTIFTYPE = 27;
    public static final int MIB_TYPE_MODID = 28;
    public static final int MIB_TYPE_NSAPADDRESS = 29;
    public static final int MIB_TYPE_AGENTCAP = 30;
    public static final int MIB_TYPE_UINTEGER = 31;
    public static final int MIB_TYPE_NULL = 32;
    public static final int MIB_TYPE_OBJGROUP = 33;
    public static final int MIB_TYPE_NOTIFGROUP = 34;
    protected static final int MIB_TAG_OBJECT = 1;
    protected static final int MIB_TAG_NAME = 2;
    protected static final int MIB_TAG_DESCRIPTION = 3;
    protected static final int MIB_TAG_ACCESS = 4;
    protected static final int MIB_TAG_STATUS = 5;
    protected static final int MIB_TAG_TYPE = 6;
    protected static final int MIB_TAG_BYTE_OID = 7;
    protected static final int MIB_TAG_WORD_OID = 8;
    protected static final int MIB_TAG_DWORD_OID = 9;
    protected static final int MIB_TAG_TEXTUAL_CONVENTION = 10;
    protected static final int MIB_TAG_INDEX = 11;
    protected static final int MIB_TAG_DISPLAY_HINT = 12;
    protected static final int MIB_END_OF_TAG = 128;
    private long id;
    private String name;
    private String description;
    private String textualConvention;
    private String displayHint;
    private String index;
    private int type;
    private int status;
    private int access;
    private Map<Long, MibObject> childObjects = new HashMap<Long, MibObject>();
    private MibObject parent;
    private SnmpObjectId objectId;

    public MibObject() {
        this.id = 0L;
        this.name = "[root]";
        this.description = "";
        this.textualConvention = null;
        this.index = null;
        this.type = -1;
        this.status = -1;
        this.access = -1;
        this.parent = null;
        this.objectId = null;
    }

    protected MibObject(NXCPDataInputStream in, MibObject parent) throws IOException, NXCException {
        this.parent = parent;
        this.name = null;
        this.description = "";
        boolean stop = false;
        while (!stop) {
            int closeTag;
            int tag = in.readUnsignedByte();
            switch (tag) {
                case 129: {
                    stop = true;
                    break;
                }
                case 7: {
                    this.id = in.readUnsignedByte();
                    break;
                }
                case 8: {
                    this.id = in.readUnsignedShort();
                    break;
                }
                case 9: {
                    this.id = in.readUnsignedInt();
                    break;
                }
                case 2: {
                    this.name = this.readStringFromStream(in);
                    break;
                }
                case 3: {
                    this.description = this.readStringFromStream(in);
                    break;
                }
                case 10: {
                    this.textualConvention = this.readStringFromStream(in);
                    break;
                }
                case 11: {
                    this.index = this.readStringFromStream(in);
                    break;
                }
                case 6: {
                    this.type = in.readUnsignedByte();
                    break;
                }
                case 5: {
                    this.status = in.readUnsignedByte();
                    break;
                }
                case 4: {
                    this.access = in.readUnsignedByte();
                    break;
                }
                case 1: {
                    MibObject object = new MibObject(in, this);
                    this.childObjects.put(object.getId(), object);
                    break;
                }
                case 12: {
                    this.displayHint = this.readStringFromStream(in);
                    break;
                }
                default: {
                    throw new NXCException(1002);
                }
            }
            if ((tag & 0xFFFFFF7F) == 1 || ((closeTag = in.readUnsignedByte()) & 0x80) != 0 && (closeTag & 0xFFFFFF7F) == tag) continue;
            throw new NXCException(1002);
        }
        if (parent == null) {
            this.name = "[root]";
            for (MibObject o : this.childObjects.values()) {
                o.setObjectIdFromParent(null);
            }
        } else if (this.name == null || this.name.isEmpty()) {
            this.name = "#" + Long.toString(this.id);
        }
    }

    private String readStringFromStream(NXCPDataInputStream in) throws IOException {
        int len = in.readUnsignedShort();
        if (len == 0) {
            return "";
        }
        byte[] buffer = new byte[len];
        in.read(buffer);
        return new String(buffer);
    }

    private void setObjectIdFromParent(SnmpObjectId oid) {
        this.objectId = new SnmpObjectId(oid, this.id);
        for (MibObject o : this.childObjects.values()) {
            o.setObjectIdFromParent(this.objectId);
        }
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        if (this.parent == null) {
            return "";
        }
        String parentName = this.parent.getFullName();
        if (parentName.isEmpty()) {
            return this.name;
        }
        return parentName + "." + this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIndex() {
        return this.index != null ? this.index : "";
    }

    public int getType() {
        return this.type;
    }

    public int getStatus() {
        return this.status;
    }

    public int getAccess() {
        return this.access;
    }

    public MibObject[] getChildObjects() {
        return this.childObjects.values().toArray(new MibObject[this.childObjects.size()]);
    }

    public MibObject getParent() {
        return this.parent;
    }

    public SnmpObjectId getObjectId() {
        return this.objectId;
    }

    public boolean hasChildren() {
        return this.childObjects.size() > 0;
    }

    protected MibObject findChildObject(SnmpObjectId oid) {
        long nextId = oid.getIdFromPos(this.objectId != null ? this.objectId.getLength() : 0);
        for (MibObject o : this.childObjects.values()) {
            if (o.getId() != nextId) continue;
            MibObject result2 = o.findChildObject(oid);
            return result2 != null ? result2 : o;
        }
        return null;
    }

    public final String getTextualConvention() {
        return this.textualConvention != null ? this.textualConvention : "";
    }

    public String getDisplayHint() {
        return this.displayHint != null ? this.displayHint : "";
    }
}

