/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TimeUnit {
    MINUTE(0),
    HOUR(1),
    DAY(2);

    private static Logger logger;
    private static Map<Integer, TimeUnit> lookupTable;
    private int value;

    private TimeUnit(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static TimeUnit getByValue(int value) {
        TimeUnit element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return HOUR;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(TimeUnit.class);
        lookupTable = new HashMap<Integer, TimeUnit>();
        for (TimeUnit element : TimeUnit.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

