/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.netxms.client.events.EventProcessingPolicyRule;

public class EventProcessingPolicy {
    private List<EventProcessingPolicyRule> rules;
    private int version;
    private List<DeletedRuleInfo> deletedRules;

    public EventProcessingPolicy(int numRules, int version2) {
        this.rules = new ArrayList<EventProcessingPolicyRule>(numRules);
        this.version = version2;
        this.deletedRules = new ArrayList<DeletedRuleInfo>();
    }

    public void addRule(EventProcessingPolicyRule rule) {
        this.rules.add(rule);
    }

    public void insertRule(EventProcessingPolicyRule rule, int index) {
        this.rules.add(index, rule);
    }

    public void deleteRule(EventProcessingPolicyRule rule) {
        if (this.rules.remove(rule) && rule.getVersion() > 0) {
            this.deletedRules.add(new DeletedRuleInfo(rule.getGuid(), rule.getVersion()));
        }
    }

    public List<EventProcessingPolicyRule> getRules() {
        return this.rules;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version2) {
        this.version = version2;
    }

    public List<DeletedRuleInfo> getDeletedRules() {
        return this.deletedRules;
    }

    public void clearDeletedRules() {
        this.deletedRules.clear();
    }

    public static class DeletedRuleInfo {
        private UUID guid;
        private int version;

        public DeletedRuleInfo(UUID guid, int version2) {
            this.guid = guid;
            this.version = version2;
        }

        public UUID getGuid() {
            return this.guid;
        }

        public int getVersion() {
            return this.version;
        }
    }
}

