/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.Set;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.PollState;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.interfaces.PollingTarget;

public class Template
extends GenericObject
implements PollingTarget {
    private int version;
    private int autoApplyFlags;
    private String autoApplyFilter;
    private int numDataCollectionItems;
    private int numPolicies;

    public Template(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.version = msg.getFieldAsInt32(178L);
        this.autoApplyFilter = msg.getFieldAsString(321L);
        this.autoApplyFlags = msg.getFieldAsInt32(625L);
        this.numDataCollectionItems = msg.getFieldAsInt32(111L);
        this.numPolicies = msg.getFieldAsInt32(629L);
    }

    public int getVersion() {
        return this.version;
    }

    public String getVersionAsString() {
        return Integer.toString(this.version);
    }

    public boolean isAutoApplyEnabled() {
        return (this.autoApplyFlags & 1) > 0;
    }

    public boolean isAutoRemoveEnabled() {
        return (this.autoApplyFlags & 2) > 0;
    }

    public int getAutoApplyFlags() {
        return this.autoApplyFlags;
    }

    public String getAutoApplyFilter() {
        return this.autoApplyFilter;
    }

    public int getNumDataCollectionItems() {
        return this.numDataCollectionItems;
    }

    public int getNumPolicies() {
        return this.numPolicies;
    }

    @Override
    public String getObjectClassName() {
        return "Template";
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public Set<String> getStrings() {
        Set<String> strings = super.getStrings();
        Template.addString(strings, this.autoApplyFilter);
        return strings;
    }

    @Override
    public int getIfXTablePolicy() {
        return 0;
    }

    @Override
    public AgentCacheMode getAgentCacheMode() {
        return null;
    }

    @Override
    public long getPollerNodeId() {
        return 0L;
    }

    @Override
    public boolean canHaveAgent() {
        return false;
    }

    @Override
    public boolean canHaveInterfaces() {
        return false;
    }

    @Override
    public boolean canHavePollerNode() {
        return false;
    }

    @Override
    public boolean canUseEtherNetIP() {
        return false;
    }

    @Override
    public boolean canUseModbus() {
        return false;
    }

    @Override
    public PollState[] getPollStates() {
        return this.pollStates;
    }
}

